#include "GetObjects.js"
#include "GetDistance.js"

function GetRadius( factory, index )
{
	var Radius = 0.0;
	
	try {
	    var val = factory.getInput(index).getValue();
	    if ( val != undefined )
	        Radius = val;
	}
	catch (e) {}

	return Radius;
}

function GatherFilletSets( factory )
{
	// The regular radius is on input index 3.

	var FilletSets = new Array();

	FilletSets.push( GetRadius( factory, 3 ) );

	// Any additional radius values for variable radius fillet come in pointlist/radius/string groups starting at index 6.

	var NumAdditionalSets = (factory.numInputs - 6) / 3;
	
	for ( var i = 0; i < NumAdditionalSets; ++i )
		FilletSets.push( GetRadius( factory, i*3 + 7 ) );
	
	return FilletSets;
}

var g_DefaultRadius = false;

function DoFillet()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.allowFaces();
	objectpicker.allowBReps();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	var factory = moi.command.createFactory( 'fillet' );
	factory.setInput( 0, objects );
	factory.disableUpdate( true );
	
	if ( !factory.doingEdges && objects.length == 1 && objects.numStandaloneCurves == 1 )
	{
		var numvertices = factory.generateVertices();
		if ( numvertices == 0 )
			return;
	
		moi.ui.beginUIUpdate();
		moi.ui.hideUI( 'SelectPrompt' );
		moi.ui.showUI( 'SelectVerticesPrompt' );
		moi.ui.endUIUpdate();
		
		objectpicker.resetAllow();
		objectpicker.allowPointObjects();
		
		if ( !GetObjects( objectpicker, true ) )
			return;
			
		factory.finishedPickingVertices();
	}
		
	moi.ui.beginUIUpdate();

	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.hideUI( 'SelectVerticesPrompt' );
	moi.ui.showUI( 'RadiusPrompt' );
	moi.ui.showUI( 'FilletOptions' );
	
	if ( factory.doingEdges )
	{
		moi.ui.showUI( 'EdgeOptionsContainer' );
		moi.ui.bindUIToInput( 'straightcorners', 'value', factory.getInput(1) );
	}

	moi.ui.endUIUpdate();

	moi.ui.bindUIToInput( 'shape', 'value', factory.getInput(4) );
	moi.ui.bindUIToInput( 'bulge', 'value', factory.getInput(5) );
	
	factory.disableUpdate( false );
	
	var event = '';
	
	function EventHandler( picker )
	{
		// Make GetDistance() return if 'newpointset' or 'currentset' have been clicked.
	
		event = picker.event;
		if ( event == 'newpointset' || event == 'currentset' )
			return true;
			
		return false;
	}
	
	var CurrentFilletSet = 0;
	var FirstTime = true;
	
	while ( 1 )
	{
		event = '';
		
		var RadiusInputIndex = 3;
		if ( CurrentFilletSet > 0 )
			RadiusInputIndex = (CurrentFilletSet-1)*3 + 7;
			
		var options = { allowzero:true, eventhandler:EventHandler, skipinitialization:!FirstTime };
		
		var result = GetDistance( factory, RadiusInputIndex, 'radiusinput', options );

	    // When setting radius for the initial fillet set, save the value so we can use it for the default value.
		if ( RadiusInputIndex == 3 )
		{
		    var r = moi.ui.commandUI.radiusinput.value;
		    if ( r != undefined )
		        g_DefaultRadius = r;
		}		
		
		if ( !result )
			return; // Canceled.
			
		FirstTime = false;
			
		if ( event == 'newpointset' )
		{
			// New point set pushed to set up a variable radius fillet, pick the points to use and then
			// create 2 new factory inputs which are a pointlist / radius pair.
		
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'FilletOptions' );
			moi.ui.hideUI( 'RadiusPrompt' );
			moi.ui.showUI( 'PickRadiusPointsPrompt' );
			moi.ui.showUI( 'RadiusPointsOptions' );
			moi.ui.endUIUpdate();
			
			factory.reset();
			
			var points = moi.createList();
			
			var pointpicker = moi.ui.createPointPicker();
			pointpicker.disableBasePt = true;
			while ( 1 )
			{
				if ( !pointpicker.waitForEvent() )
					return false;
					
				if ( pointpicker.event == 'finished' )
					points.add( pointpicker.pt );
					
				if ( pointpicker.event == 'done' )
					break;					
			}
			
			if ( points.length > 0 )
			{
				factory.createInput( 'list' );
				factory.setInput( factory.numInputs-1, points );
				factory.createInput( 'double' );
				factory.setInput( factory.numInputs-1, -1.0 );
				factory.createInput( 'string' );
				factory.setInput( factory.numInputs-1, moi.ui.commandUI.linearblend.value ? 'linear' : '' );
				
				var FilletSets = GatherFilletSets( factory );
				CurrentFilletSet = FilletSets.length-1;
				moi.ui.commandUI.UpdateCurrentFilletSet( CurrentFilletSet );
				factory.showPointSet( CurrentFilletSet );
			}
				
			moi.ui.beginUIUpdate();
			moi.ui.showUI( 'FilletOptions' );
			moi.ui.showUI( 'RadiusPrompt' );
			moi.ui.hideUI( 'PickRadiusPointsPrompt' );
			moi.ui.hideUI( 'RadiusPointsOptions' );
			moi.ui.endUIUpdate();
			
			moi.ui.clearPickedPoints();
		}
		else if ( event == 'currentset' )
		{
			// Current set label clicked, show menu to allow switching the active fillet set.
			
			var DoMenu = true;
			
			while ( DoMenu )
			{
				var FilletSets = GatherFilletSets(factory);
				var result = moi.ui.commandUI.DoFilletSetMenu( FilletSets, CurrentFilletSet );
				
				DoMenu = false;
			
				if ( result != -1 ) // return of -1 means menu was canceled.
				{
					var NeedFactoryUpdate = false;
				
					if ( result >= 0 )
					{
						// Result of 0 or higher means set current fillet set to that index.					
						CurrentFilletSet = result;
					}
					else
					{
						// Return of -2 or below means remove fillet set and show menu again.
						
						DoMenu = true;
						
						var BaseIndexToRemove = -(result+1);
						if ( BaseIndexToRemove > 0 )
						{
							var FactoryIndexToRemove = (BaseIndexToRemove-1) * 3 + 6;
							factory.removeInput( FactoryIndexToRemove );
							factory.removeInput( FactoryIndexToRemove );
							factory.removeInput( FactoryIndexToRemove );
							
							if ( CurrentFilletSet >= BaseIndexToRemove )
								CurrentFilletSet = CurrentFilletSet-1;

							FilletSets = GatherFilletSets(factory);
							NeedFactoryUpdate = true;
						}
					}
					
					{
						moi.ui.commandUI.UpdateCurrentFilletSet( CurrentFilletSet );
						factory.showPointSet( CurrentFilletSet );
					
						var Radius = FilletSets[CurrentFilletSet];
						if ( Radius >= 0.0 )
							moi.ui.commandUI.radiusinput.value = Radius;
							
						if ( NeedFactoryUpdate )
							factory.update();
					}
				}
			}
		}
		else
		{
			// Done.
			break;
		}
	}
	
	factory.commit();
}

DoFillet();

// Set radius set 0 value on to control so it will be the starting default value on the next run through.
if ( g_DefaultRadius !== false )
	moi.ui.commandUI.radiusinput.value = g_DefaultRadius;

